<?php
/*
 * @author    Daan Vos de Wael
 * @copyright Copyright (c) 2013, Daan Vos de Wael, http://www.daanvosdewael.com
 * @license   http://en.wikipedia.org/wiki/MIT_License The MIT License
*/

  function jswpla_gallery_metabox_enqueue($hook) {
    if ( 'post.php' == $hook || 'post-new.php' == $hook ) {
      wp_enqueue_script('gallery-metabox', plugins_url('js/gallery-metabox.js', __FILE__), array('jquery', 'jquery-ui-sortable'));
      wp_enqueue_style('gallery-metabox', plugins_url('css/gallery-metabox.css', __FILE__));
    }
  }
  add_action('admin_enqueue_scripts', 'jswpla_gallery_metabox_enqueue');

  function jswpla_add_gallery_metabox($post_type) {
    $types = array('joomsport_team', 'joomsport_player', 'joomsport_venue', 'joomsport_match', 'joomsport_person');

    if (in_array($post_type, $types)) {
      add_meta_box(
        'gallery-metabox',
        'Gallery',
        'jswpla_gallery_meta_callback',
        $post_type,
        'normal',
        'high'
      );
    }
  }
  add_action('add_meta_boxes', 'jswpla_add_gallery_metabox');

  function jswpla_gallery_meta_callback($post) {
    wp_nonce_field( basename(__FILE__), 'gallery_meta_nonce' );
    $ids = get_post_meta($post->ID, 'vdw_gallery_id', true);

    ?>
    <table class="form-table">
      <tr><td>
        <a class="gallery-add button" href="#" data-uploader-title="Add image(s) to gallery" data-uploader-button-text="Add image(s)">Add image(s)</a>

        <ul id="gallery-metabox-list">
        <?php if ($ids) : foreach ($ids as $key => $value) : $image = wp_get_attachment_image_src($value); ?>

          <li>
            <input type="hidden" name="vdw_gallery_id[<?php echo intval($key); ?>]" value="<?php echo esc_attr($value); ?>">
            <img class="image-preview" src="<?php echo esc_url($image[0]); ?>">
            <small><a class="remove-image" href="#">Remove image</a></small>
          </li>

        <?php endforeach; endif; ?>
        </ul>

      </td></tr>
    </table>
  <?php }

  function jswpla_gallery_meta_save($post_id) {
    if (!isset($_POST['gallery_meta_nonce']) || !wp_verify_nonce($_POST['gallery_meta_nonce'], basename(__FILE__))) return;

    if (!current_user_can('edit_post', $post_id)) return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if(isset($_POST['vdw_gallery_id'])) {
      update_post_meta($post_id, 'vdw_gallery_id', array_map('intval', $_POST['vdw_gallery_id']));
      
    } else {
      delete_post_meta($post_id, 'vdw_gallery_id');

    }
  }
  add_action('save_post', 'jswpla_gallery_meta_save');

?>