<?php
/**
 * Class wp_megamenu_initial_setup
 */
if ( ! class_exists('wp_megamenu_initial_setup')) {
    class wp_megamenu_initial_setup{

        /**
         * @return wp_megamenu_initial_setup
         */
        public static function init(){
            $return = new self();
            return $return;
        }

        /**
         * wp_megamenu_initial_setup constructor.
         */
        public function __construct() {
            register_activation_hook( WPMM_FILE, array($this, 'initial_setup') );
        }

        /**
         * Save all required values
         */
        public function initial_setup(){
            $WPMM_VER = get_option('WPMM_VER');
            if (! $WPMM_VER){
                //Add Theme
                $this->add_initial_theme();
                //Adding default settings
                $settings_option = unserialize($this->settings_option());
                update_option('wpmm_options', $settings_option);
            }
            //Add plugin version
            update_option('WPMM_VER', WPMM_VER);

	        //Showing default menu theme in nav page
	        $user_id = get_current_user_id();
	        update_user_meta($user_id, 'metaboxhidden_nav-menus', array());
	        //$this->set_wpmm_initial_menu();


            # Auto increase remove Inactive Widget problem
            $sidebars_widgets = get_option( 'sidebars_widgets' );
            $sidebars_widgets['wp_inactive_widgets'] = array();
            update_option( 'sidebars_widgets', $sidebars_widgets );
        }

        public function add_initial_theme(){
            $predefined_themes = $this->predefined_themes_function();
            foreach($predefined_themes as $serilized_data){
                $post_data = unserialize($serilized_data);
                $required_keys = array('post_title', 'post_content', 'post_type', 'post_status');
                if (array_keys_exist($required_keys, $post_data)) {
                    $imported_post_id = wp_insert_post($post_data);
                }
            }
        }

        public function settings_option(){
            $option = 'a:6:{s:19:"css_output_location";s:10:"filesystem";s:13:"container_tag";s:3:"nav";s:19:"enable_font_awesome";s:6:"enable";s:21:"responsive_breakpoint";s:5:"767px";s:14:"enable_icofont";s:6:"enable";s:22:"disable_wpmm_on_mobile";i:0;}';
            return $option;
        }

        public function predefined_themes_function(){
            $wpmm_predefined_themes[] = 'a:4:{s:10:"post_title";s:14:"classic-themes";s:12:"post_content";s:8298:"a:192:{s:18:"enable_sticky_menu";s:4:"true";s:6:"zindex";s:4:"9999";s:19:"dropdown_arrow_down";s:13:"fa-angle-down";s:20:"dropdown_arrow_right";s:14:"fa-angle-right";s:17:"enable_search_bar";s:4:"true";s:10:"brand_logo";s:87:"http://demo.themeum.com/wordpress/wp-megamenu/wp-content/uploads/2017/07/brand-logo.png";s:16:"brand_logo_width";s:2:"32";s:17:"brand_logo_height";s:2:"31";s:15:"logo_margin_top";s:2:"11";s:17:"logo_margin_right";s:2:"15";s:18:"logo_margin_bottom";s:0:"";s:16:"logo_margin_left";s:0:"";s:10:"menu_align";s:4:"left";s:14:"menubar_height";s:0:"";s:10:"menubar_bg";s:7:"#fbfbfb";s:16:"menu_padding_top";s:0:"";s:18:"menu_padding_right";s:2:"20";s:19:"menu_padding_bottom";s:0:"";s:17:"menu_padding_left";s:2:"20";s:27:"menu_border_radius_top_left";s:0:"";s:21:"menu_radius_top_right";s:0:"";s:23:"menu_radius_bottom_left";s:0:"";s:24:"menu_radius_bottom_right";s:0:"";s:10:"top_shadow";s:0:"";s:12:"right_shadow";s:0:"";s:13:"bottom_shadow";s:0:"";s:11:"left_shadow";s:0:"";s:17:"wpmm_theme_shadow";s:0:"";s:24:"menubar_top_border_width";s:0:"";s:26:"menubar_right_border_width";s:0:"";s:27:"menubar_bottom_border_width";s:0:"";s:25:"menubar_left_border_width";s:0:"";s:16:"menu_border_type";s:4:"none";s:17:"menu_border_color";s:0:"";s:24:"top_level_item_text_font";s:7:"Poppins";s:25:"top_level_item_text_color";s:7:"#000000";s:31:"top_level_item_text_hover_color";s:7:"#2964d8";s:29:"top_level_item_text_font_size";s:4:"14px";s:31:"top_level_item_text_font_weight";s:3:"500";s:31:"top_level_item_text_line_height";s:2:"24";s:29:"top_level_item_text_transform";s:9:"uppercase";s:34:"top_level_item_text_letter_spacing";s:2:".5";s:23:"top_level_item_bg_color";s:0:"";s:29:"top_level_item_bg_hover_color";s:0:"";s:26:"top_level_item_padding_top";s:0:"";s:28:"top_level_item_padding_right";s:0:"";s:29:"top_level_item_padding_bottom";s:0:"";s:27:"top_level_item_padding_left";s:0:"";s:25:"top_level_item_margin_top";s:0:"";s:27:"top_level_item_margin_right";s:0:"";s:28:"top_level_item_margin_bottom";s:0:"";s:26:"top_level_item_margin_left";s:0:"";s:27:"top_level_item_border_width";s:0:"";s:26:"top_level_item_border_type";s:0:"";s:27:"top_level_item_border_color";s:0:"";s:33:"top_level_item_hover_border_width";s:0:"";s:32:"top_level_item_hover_border_type";s:4:"none";s:33:"top_level_item_hover_border_color";s:0:"";s:19:"dropdown_menu_width";s:3:"220";s:16:"dropdown_menu_bg";s:7:"#ffffff";s:25:"dropdown_menu_padding_top";s:0:"";s:27:"dropdown_menu_padding_right";s:0:"";s:28:"dropdown_menu_padding_bottom";s:0:"";s:26:"dropdown_menu_padding_left";s:0:"";s:36:"dropdown_menu_border_radius_top_left";s:0:"";s:30:"dropdown_menu_radius_top_right";s:0:"";s:32:"dropdown_menu_radius_bottom_left";s:0:"";s:33:"dropwodn_menu_radius_bottom_right";s:0:"";s:26:"dropdown_menu_border_width";s:0:"";s:25:"dropdown_menu_border_type";s:4:"none";s:26:"dropdown_menu_border_color";s:0:"";s:31:"dropdown_submenu_item_text_font";s:7:"Poppins";s:32:"dropdown_submenu_item_text_color";s:7:"#282828";s:38:"dropdown_submenu_item_text_hover_color";s:7:"#2964d8";s:36:"dropdown_submenu_item_text_font_size";s:4:"13px";s:38:"dropdown_submenu_item_text_font_weight";s:3:"300";s:38:"dropdown_submenu_item_text_line_height";s:2:"24";s:36:"dropdown_submenu_item_text_transform";s:10:"capitalize";s:41:"dropdown_submenu_item_text_letter_spacing";s:0:"";s:30:"dropdown_submenu_item_bg_color";s:7:"inherit";s:36:"dropdown_submenu_item_bg_hover_color";s:7:"inherit";s:33:"dropdown_submenu_item_padding_top";s:1:"3";s:35:"dropdown_submenu_item_padding_right";s:0:"";s:36:"dropdown_submenu_item_padding_bottom";s:1:"3";s:34:"dropdown_submenu_item_padding_left";s:0:"";s:32:"dropdown_submenu_item_margin_top";s:0:"";s:34:"dropdown_submenu_item_margin_right";s:0:"";s:35:"dropdown_submenu_item_margin_bottom";s:0:"";s:33:"dropdown_submenu_item_margin_left";s:0:"";s:34:"dropdown_submenu_item_border_width";s:0:"";s:33:"dropdown_submenu_item_border_type";s:4:"none";s:34:"dropdown_submenu_item_border_color";s:0:"";s:40:"dropdown_submenu_item_hover_border_width";s:0:"";s:39:"dropdown_submenu_item_hover_border_type";s:4:"none";s:40:"dropdown_submenu_item_hover_border_color";s:0:"";s:38:"dropdown_submenu_first_item_text_color";s:7:"inherit";s:44:"dropdown_submenu_first_item_text_hover_color";s:7:"#2964d8";s:42:"dropdown_submenu_first_item_text_font_size";s:4:"13px";s:44:"dropdown_submenu_first_item_text_font_weight";s:3:"600";s:44:"dropdown_submenu_first_item_text_line_height";s:2:"25";s:42:"dropdown_submenu_first_item_text_transform";s:9:"uppercase";s:47:"dropdown_submenu_first_item_text_letter_spacing";s:2:".5";s:29:"widgets_first_item_margin_top";s:0:"";s:31:"widgets_first_item_margin_right";s:0:"";s:32:"widgets_first_item_margin_bottom";s:1:"5";s:30:"widgets_first_item_margin_left";s:0:"";s:41:"submenu_first_item_border_separator_width";s:0:"";s:40:"submenu_first_item_border_separator_type";s:4:"none";s:41:"submenu_first_item_border_separator_color";s:0:"";s:17:"megamenu_bg_color";s:7:"#ffffff";s:15:"mega_menu_width";s:4:"100%";s:20:"megamenu_padding_top";s:0:"";s:22:"megamenu_padding_right";s:0:"";s:23:"megamenu_padding_bottom";s:0:"";s:21:"megamenu_padding_left";s:0:"";s:31:"megamenu_border_radius_top_left";s:0:"";s:25:"megamenu_radius_top_right";s:0:"";s:27:"megamenu_radius_bottom_left";s:0:"";s:28:"megamenu_radius_bottom_right";s:0:"";s:26:"megamenu_menu_border_width";s:0:"";s:25:"megamenu_menu_border_type";s:4:"none";s:26:"megamenu_menu_border_color";s:0:"";s:36:"megamenu_menu_border_separator_width";s:0:"";s:35:"megamenu_menu_border_separator_type";s:5:"solid";s:36:"megamenu_menu_border_separator_color";s:0:"";s:22:"megamenu_boxshadow_top";s:0:"";s:24:"megamenu_boxshadow_right";s:0:"";s:25:"megamenu_boxshadow_bottom";s:0:"";s:23:"megamenu_boxshadow_left";s:0:"";s:24:"megamenu_boxshadow_color";s:0:"";s:26:"widgets_heading_text_color";s:7:"#000000";s:32:"widgets_heading_text_hover_color";s:0:"";s:30:"widgets_heading_text_font_size";s:4:"13px";s:32:"widgets_heading_text_font_weight";s:3:"600";s:32:"widgets_heading_text_line_height";s:2:"25";s:30:"widgets_heading_text_transform";s:9:"uppercase";s:35:"widgets_heading_text_letter_spacing";s:2:".5";s:40:"widget_first_item_border_separator_width";s:0:"";s:39:"widget_first_item_border_separator_type";s:4:"none";s:40:"widget_first_item_border_separator_color";s:0:"";s:19:"widgets_padding_top";s:0:"";s:21:"widgets_padding_right";s:0:"";s:22:"widgets_padding_bottom";s:0:"";s:20:"widgets_padding_left";s:0:"";s:18:"widgets_margin_top";s:0:"";s:20:"widgets_margin_right";s:0:"";s:21:"widgets_margin_bottom";s:0:"";s:19:"widgets_margin_left";s:0:"";s:20:"widgets_border_width";s:0:"";s:19:"widgets_border_type";s:4:"none";s:20:"widgets_border_color";s:0:"";s:26:"widgets_hover_border_width";s:0:"";s:25:"widgets_hover_border_type";s:4:"none";s:26:"widgets_hover_border_color";s:0:"";s:21:"widgets_content_color";s:7:"#333333";s:20:"toggle_bar_alignment";s:5:"right";s:20:"toggle_btn_open_text";s:4:"Menu";s:21:"toggle_btn_text_color";s:7:"#ffffff";s:27:"toggle_btn_text_hover_color";s:7:"#ffffff";s:20:"toggle_bar_font_size";s:4:"14px";s:20:"togglebar_margin_top";s:2:"12";s:22:"togglebar_margin_right";s:0:"";s:23:"togglebar_margin_bottom";s:2:"12";s:21:"togglebar_margin_left";s:0:"";s:13:"toggle_bar_bg";s:7:"#2964d8";s:19:"toggle_bar_hover_bg";s:7:"#2844d3";s:14:"mobile_menu_bg";s:0:"";s:10:"wpmm_class";s:0:"";s:10:"custom_css";s:0:"";s:9:"custom_js";s:0:"";s:19:"enable_social_links";s:4:"true";s:19:"social_links_target";s:6:"_blank";s:21:"social_links_facebook";s:33:"https://www.facebook.com/themeum/";s:20:"social_links_twitter";s:28:"https://twitter.com/themeum/";s:18:"social_links_gplus";s:0:"";s:22:"social_links_instagram";s:0:"";s:21:"social_links_linkedin";s:0:"";s:22:"social_links_pinterest";s:0:"";s:20:"social_links_youtube";s:0:"";s:21:"social_links_dribbble";s:0:"";s:20:"social_links_behance";s:0:"";s:17:"social_links_digg";s:0:"";s:18:"social_links_vimeo";s:0:"";s:24:"social_links_stumbleupon";s:0:"";s:19:"social_links_reddit";s:0:"";s:22:"social_links_delicious";s:0:"";s:18:"social_links_skype";s:0:"";s:19:"social_links_github";s:0:"";s:19:"social_links_amazon";s:0:"";s:21:"social_links_whatsapp";s:0:"";s:23:"social_links_soundcloud";s:0:"";s:14:"animation_type";s:10:"fadeindown";}";s:9:"post_type";s:10:"wpmm_theme";s:11:"post_status";s:7:"publish";}';

            $wpmm_predefined_themes[] = 'a:4:{s:10:"post_title";s:11:"modern-dark";s:12:"post_content";s:11034:"a:254:{s:6:"zindex";s:0:"";s:19:"dropdown_arrow_down";s:13:"fa-angle-down";s:19:"dropdown_arrow_left";s:13:"fa-angle-left";s:20:"dropdown_arrow_right";s:14:"fa-angle-right";s:17:"enable_search_bar";s:4:"true";s:24:"search_field_placeholder";s:0:"";s:12:"cta_btn_text";s:0:"";s:12:"cta_btn_link";s:0:"";s:13:"cta_btn_color";s:7:"#ffffff";s:19:"cta_btn_hover_color";s:7:"#ffffff";s:10:"cta_btn_bg";s:7:"#009ceb";s:16:"cta_btn_hover_bg";s:7:"#009ae8";s:12:"cta_btn_font";s:9:"Open Sans";s:17:"cta_btn_font_size";s:4:"16px";s:19:"cta_btn_font_weight";s:3:"600";s:19:"cta_btn_line_height";s:0:"";s:22:"cta_btn_text_transform";s:10:"capitalize";s:22:"cta_btn_letter_spacing";s:0:"";s:15:"cta_padding_top";s:0:"";s:17:"cta_padding_right";s:0:"";s:18:"cta_padding_bottom";s:0:"";s:16:"cta_padding_left";s:0:"";s:14:"cta_margin_top";s:4:"13px";s:16:"cta_margin_right";s:0:"";s:17:"cta_margin_bottom";s:0:"";s:15:"cta_margin_left";s:4:"10px";s:24:"cta_btn_top_border_width";s:0:"";s:26:"cta_btn_right_border_width";s:0:"";s:27:"cta_btn_bottom_border_width";s:0:"";s:25:"cta_btn_left_border_width";s:0:"";s:19:"cta_btn_border_type";s:4:"none";s:20:"cta_btn_border_color";s:0:"";s:26:"cta_btn_border_hover_color";s:0:"";s:30:"cta_btn_border_radius_top_left";s:0:"";s:24:"cta_btn_radius_top_right";s:0:"";s:22:"cta_radius_bottom_left";s:0:"";s:23:"cta_radius_bottom_right";s:0:"";s:36:"cta_btn_border_radius_top_left_hover";s:0:"";s:30:"cta_btn_radius_top_right_hover";s:0:"";s:28:"cta_radius_bottom_left_hover";s:0:"";s:29:"cta_radius_bottom_right_hover";s:0:"";s:16:"wpmm_orientation";s:15:"wpmm_horizontal";s:22:"wpmm_orientation_align";s:20:"wpmm_horizontal_left";s:24:"wpmm_vertical_menu_width";s:5:"220px";s:29:"wpmm_vertical_container_width";s:6:"1140px";s:10:"brand_logo";s:87:"http://demo.themeum.com/wordpress/wp-megamenu/wp-content/uploads/2017/07/brand-logo.png";s:16:"brand_logo_width";s:2:"38";s:17:"brand_logo_height";s:2:"38";s:15:"logo_margin_top";s:2:"16";s:17:"logo_margin_right";s:2:"15";s:18:"logo_margin_bottom";s:0:"";s:16:"logo_margin_left";s:0:"";s:10:"menu_align";s:5:"right";s:14:"menubar_height";s:4:"70px";s:10:"menubar_bg";s:7:"#31313e";s:12:"menubar_bg_2";s:0:"";s:25:"menubar_bg_gradient_angle";s:3:"-90";s:9:"sticky_bg";s:0:"";s:11:"sticky_bg_2";s:0:"";s:24:"sticky_bg_gradient_angle";s:3:"-90";s:16:"menu_padding_top";s:0:"";s:18:"menu_padding_right";s:2:"20";s:19:"menu_padding_bottom";s:0:"";s:17:"menu_padding_left";s:2:"20";s:27:"menu_border_radius_top_left";s:0:"";s:21:"menu_radius_top_right";s:0:"";s:23:"menu_radius_bottom_left";s:0:"";s:24:"menu_radius_bottom_right";s:0:"";s:10:"top_shadow";s:0:"";s:12:"right_shadow";s:0:"";s:13:"bottom_shadow";s:0:"";s:11:"left_shadow";s:0:"";s:17:"wpmm_theme_shadow";s:0:"";s:24:"menubar_top_border_width";s:1:"0";s:26:"menubar_right_border_width";s:1:"0";s:27:"menubar_bottom_border_width";s:0:"";s:25:"menubar_left_border_width";s:1:"0";s:16:"menu_border_type";s:4:"none";s:17:"menu_border_color";s:0:"";s:24:"top_level_item_text_font";s:9:"Open Sans";s:25:"top_level_item_text_color";s:21:"rgba(255,255,255,0.7)";s:31:"top_level_item_text_hover_color";s:7:"#ffffff";s:29:"top_level_item_text_font_size";s:4:"16px";s:31:"top_level_item_text_font_weight";s:3:"500";s:31:"top_level_item_text_line_height";s:2:"24";s:29:"top_level_item_text_transform";s:10:"capitalize";s:34:"top_level_item_text_letter_spacing";s:2:".5";s:23:"top_level_item_bg_color";s:0:"";s:25:"top_level_item_bg_color_2";s:0:"";s:38:"top_level_item_bg_color_gradient_angle";s:3:"-90";s:29:"top_level_item_bg_hover_color";s:0:"";s:31:"top_level_item_bg_hover_color_2";s:0:"";s:44:"top_level_item_bg_hover_color_gradient_angle";s:3:"-90";s:26:"top_level_item_padding_top";s:4:"23px";s:28:"top_level_item_padding_right";s:4:"14px";s:29:"top_level_item_padding_bottom";s:4:"23px";s:27:"top_level_item_padding_left";s:4:"14px";s:25:"top_level_item_margin_top";s:0:"";s:27:"top_level_item_margin_right";s:0:"";s:28:"top_level_item_margin_bottom";s:0:"";s:26:"top_level_item_margin_left";s:0:"";s:27:"top_level_item_border_width";s:0:"";s:33:"top_level_item_border_width_right";s:0:"";s:34:"top_level_item_border_width_bottom";s:0:"";s:32:"top_level_item_border_width_left";s:0:"";s:26:"top_level_item_border_type";s:0:"";s:27:"top_level_item_border_color";s:0:"";s:33:"top_level_item_hover_border_width";s:0:"";s:39:"top_level_item_hover_border_width_right";s:0:"";s:40:"top_level_item_hover_border_width_bottom";s:0:"";s:38:"top_level_item_hover_border_width_left";s:0:"";s:32:"top_level_item_hover_border_type";s:4:"none";s:33:"top_level_item_hover_border_color";s:0:"";s:19:"dropdown_menu_width";s:3:"220";s:16:"dropdown_menu_bg";s:7:"#3d3d4c";s:18:"dropdown_menu_bg_2";s:0:"";s:31:"dropdown_menu_bg_gradient_angle";s:3:"-90";s:25:"dropdown_menu_padding_top";s:0:"";s:27:"dropdown_menu_padding_right";s:0:"";s:28:"dropdown_menu_padding_bottom";s:0:"";s:26:"dropdown_menu_padding_left";s:0:"";s:36:"dropdown_menu_border_radius_top_left";s:0:"";s:30:"dropdown_menu_radius_top_right";s:0:"";s:32:"dropdown_menu_radius_bottom_left";s:0:"";s:33:"dropwodn_menu_radius_bottom_right";s:0:"";s:26:"dropdown_menu_border_width";s:0:"";s:25:"dropdown_menu_border_type";s:4:"none";s:26:"dropdown_menu_border_color";s:7:"#d3a538";s:31:"dropdown_submenu_item_text_font";s:9:"Open Sans";s:32:"dropdown_submenu_item_text_color";s:21:"rgba(255,255,255,0.7)";s:38:"dropdown_submenu_item_text_hover_color";s:7:"#ffffff";s:36:"dropdown_submenu_item_text_font_size";s:4:"14px";s:38:"dropdown_submenu_item_text_font_weight";s:3:"600";s:38:"dropdown_submenu_item_text_line_height";s:2:"24";s:36:"dropdown_submenu_item_text_transform";s:10:"capitalize";s:41:"dropdown_submenu_item_text_letter_spacing";s:0:"";s:38:"dropdown_submenu_first_item_text_color";s:7:"#e8e8e8";s:44:"dropdown_submenu_first_item_text_hover_color";s:7:"#ffffff";s:42:"dropdown_submenu_first_item_text_font_size";s:4:"13px";s:44:"dropdown_submenu_first_item_text_font_weight";s:3:"600";s:44:"dropdown_submenu_first_item_text_line_height";s:2:"25";s:42:"dropdown_submenu_first_item_text_transform";s:9:"uppercase";s:47:"dropdown_submenu_first_item_text_letter_spacing";s:2:".5";s:30:"dropdown_submenu_item_bg_color";s:7:"inherit";s:36:"dropdown_submenu_item_bg_hover_color";s:7:"inherit";s:33:"dropdown_submenu_item_padding_top";s:3:"5px";s:35:"dropdown_submenu_item_padding_right";s:4:"15px";s:36:"dropdown_submenu_item_padding_bottom";s:3:"5px";s:34:"dropdown_submenu_item_padding_left";s:4:"15px";s:32:"dropdown_submenu_item_margin_top";s:0:"";s:34:"dropdown_submenu_item_margin_right";s:0:"";s:35:"dropdown_submenu_item_margin_bottom";s:0:"";s:33:"dropdown_submenu_item_margin_left";s:0:"";s:34:"dropdown_submenu_item_border_width";s:0:"";s:33:"dropdown_submenu_item_border_type";s:4:"none";s:34:"dropdown_submenu_item_border_color";s:0:"";s:40:"dropdown_submenu_item_hover_border_width";s:0:"";s:39:"dropdown_submenu_item_hover_border_type";s:4:"none";s:40:"dropdown_submenu_item_hover_border_color";s:0:"";s:29:"widgets_first_item_margin_top";s:0:"";s:31:"widgets_first_item_margin_right";s:0:"";s:32:"widgets_first_item_margin_bottom";s:1:"5";s:30:"widgets_first_item_margin_left";s:0:"";s:41:"submenu_first_item_border_separator_width";s:0:"";s:40:"submenu_first_item_border_separator_type";s:4:"none";s:41:"submenu_first_item_border_separator_color";s:0:"";s:17:"megamenu_bg_color";s:7:"#3d3d4c";s:15:"mega_menu_width";s:4:"100%";s:20:"megamenu_padding_top";s:0:"";s:22:"megamenu_padding_right";s:0:"";s:23:"megamenu_padding_bottom";s:0:"";s:21:"megamenu_padding_left";s:0:"";s:31:"megamenu_border_radius_top_left";s:0:"";s:25:"megamenu_radius_top_right";s:0:"";s:27:"megamenu_radius_bottom_left";s:0:"";s:28:"megamenu_radius_bottom_right";s:0:"";s:26:"megamenu_menu_border_width";s:0:"";s:25:"megamenu_menu_border_type";s:4:"none";s:26:"megamenu_menu_border_color";s:0:"";s:36:"megamenu_menu_border_separator_width";s:0:"";s:35:"megamenu_menu_border_separator_type";s:5:"solid";s:36:"megamenu_menu_border_separator_color";s:0:"";s:22:"megamenu_boxshadow_top";s:0:"";s:24:"megamenu_boxshadow_right";s:0:"";s:25:"megamenu_boxshadow_bottom";s:0:"";s:23:"megamenu_boxshadow_left";s:0:"";s:24:"megamenu_boxshadow_color";s:0:"";s:26:"widgets_heading_text_color";s:7:"#ffffff";s:32:"widgets_heading_text_hover_color";s:7:"#ffffff";s:30:"widgets_heading_text_font_size";s:4:"13px";s:32:"widgets_heading_text_font_weight";s:3:"600";s:32:"widgets_heading_text_line_height";s:2:"25";s:30:"widgets_heading_text_transform";s:9:"uppercase";s:35:"widgets_heading_text_letter_spacing";s:2:".5";s:40:"widget_first_item_border_separator_width";s:0:"";s:39:"widget_first_item_border_separator_type";s:4:"none";s:40:"widget_first_item_border_separator_color";s:7:"#ffffff";s:26:"widgets_heading_margin_top";s:0:"";s:28:"widgets_heading_margin_right";s:0:"";s:29:"widgets_heading_margin_bottom";s:0:"";s:27:"widgets_heading_margin_left";s:0:"";s:19:"widgets_padding_top";s:0:"";s:21:"widgets_padding_right";s:0:"";s:22:"widgets_padding_bottom";s:0:"";s:20:"widgets_padding_left";s:0:"";s:18:"widgets_margin_top";s:0:"";s:20:"widgets_margin_right";s:0:"";s:21:"widgets_margin_bottom";s:0:"";s:19:"widgets_margin_left";s:0:"";s:20:"widgets_border_width";s:0:"";s:19:"widgets_border_type";s:4:"none";s:20:"widgets_border_color";s:0:"";s:26:"widgets_hover_border_width";s:0:"";s:25:"widgets_hover_border_type";s:4:"none";s:26:"widgets_hover_border_color";s:0:"";s:21:"widgets_content_color";s:7:"#ffffff";s:20:"toggle_bar_alignment";s:5:"right";s:20:"toggle_btn_open_text";s:4:"Menu";s:21:"toggle_bar_close_icon";s:4:"true";s:21:"toggle_btn_text_color";s:7:"#ffffff";s:27:"toggle_btn_text_hover_color";s:7:"#ffffff";s:20:"toggle_bar_font_size";s:4:"14px";s:20:"togglebar_margin_top";s:2:"21";s:22:"togglebar_margin_right";s:0:"";s:23:"togglebar_margin_bottom";s:2:"21";s:21:"togglebar_margin_left";s:0:"";s:13:"toggle_bar_bg";s:7:"#009ceb";s:19:"toggle_bar_hover_bg";s:7:"#009ceb";s:26:"mobile_item_text_font_size";s:4:"14px";s:28:"mobile_item_text_font_weight";s:3:"400";s:28:"mobile_item_text_line_height";s:0:"";s:26:"mobile_item_text_transform";s:10:"capitalize";s:31:"mobile_item_text_letter_spacing";s:0:"";s:22:"mobile_menu_item_color";s:7:"#ffffff";s:28:"mobile_menu_item_hover_color";s:0:"";s:28:"mobile_menu_item_padding_top";s:4:"10px";s:30:"mobile_menu_item_padding_right";s:0:"";s:31:"mobile_menu_item_padding_bottom";s:4:"10px";s:29:"mobile_menu_item_padding_left";s:0:"";s:27:"mobile_menu_item_margin_top";s:0:"";s:29:"mobile_menu_item_margin_right";s:0:"";s:30:"mobile_menu_item_margin_bottom";s:0:"";s:28:"mobile_menu_item_margin_left";s:0:"";s:14:"mobile_menu_bg";s:7:"#3d3d4c";s:16:"mobile_menu_bg_2";s:0:"";s:29:"mobile_menu_bg_gradient_angle";s:3:"-90";s:10:"wpmm_class";s:0:"";s:10:"custom_css";s:0:"";s:9:"custom_js";s:0:"";s:19:"social_links_target";s:6:"_blank";s:12:"social_color";s:0:"";s:18:"social_hover_color";s:0:"";s:11:"social_icon";a:2:{s:4:"icon";a:1:{i:0;s:0:"";}s:3:"url";a:1:{i:0;s:0:"";}}s:14:"animation_type";s:10:"fadeindown";}";s:9:"post_type";s:10:"wpmm_theme";s:11:"post_status";s:7:"publish";}';

            $wpmm_predefined_themes[] = 'a:4:{s:10:"post_title";s:12:"classic-blue";s:12:"post_content";s:9519:"a:215:{s:6:"zindex";s:4:"9999";s:19:"dropdown_arrow_down";s:13:"fa-angle-down";s:19:"dropdown_arrow_left";s:13:"fa-angle-left";s:20:"dropdown_arrow_right";s:14:"fa-angle-right";s:17:"enable_search_bar";s:4:"true";s:24:"search_field_placeholder";s:0:"";s:10:"brand_logo";s:87:"http://demo.themeum.com/wordpress/wp-megamenu/wp-content/uploads/2017/07/brand-logo.png";s:16:"brand_logo_width";s:2:"40";s:17:"brand_logo_height";s:2:"40";s:15:"logo_margin_top";s:2:"17";s:17:"logo_margin_right";s:2:"15";s:18:"logo_margin_bottom";s:0:"";s:16:"logo_margin_left";s:0:"";s:10:"menu_align";s:5:"right";s:14:"menubar_height";s:0:"";s:10:"menubar_bg";s:7:"#145bca";s:12:"menubar_bg_2";s:0:"";s:25:"menubar_bg_gradient_angle";s:3:"-90";s:9:"sticky_bg";s:7:"#145bca";s:11:"sticky_bg_2";s:0:"";s:24:"sticky_bg_gradient_angle";s:3:"-90";s:16:"menu_padding_top";s:0:"";s:18:"menu_padding_right";s:2:"20";s:19:"menu_padding_bottom";s:0:"";s:17:"menu_padding_left";s:2:"20";s:27:"menu_border_radius_top_left";s:0:"";s:21:"menu_radius_top_right";s:0:"";s:23:"menu_radius_bottom_left";s:0:"";s:24:"menu_radius_bottom_right";s:0:"";s:10:"top_shadow";s:0:"";s:12:"right_shadow";s:0:"";s:13:"bottom_shadow";s:0:"";s:11:"left_shadow";s:0:"";s:17:"wpmm_theme_shadow";s:0:"";s:24:"menubar_top_border_width";s:1:"0";s:26:"menubar_right_border_width";s:1:"0";s:27:"menubar_bottom_border_width";s:3:"3px";s:25:"menubar_left_border_width";s:1:"0";s:16:"menu_border_type";s:5:"solid";s:17:"menu_border_color";s:7:"#145bca";s:24:"top_level_item_text_font";s:9:"Open Sans";s:25:"top_level_item_text_color";s:21:"rgba(255,255,255,0.8)";s:31:"top_level_item_text_hover_color";s:7:"#ffffff";s:29:"top_level_item_text_font_size";s:4:"16px";s:31:"top_level_item_text_font_weight";s:3:"400";s:31:"top_level_item_text_line_height";s:2:"24";s:29:"top_level_item_text_transform";s:10:"capitalize";s:34:"top_level_item_text_letter_spacing";s:2:".5";s:23:"top_level_item_bg_color";s:7:"#145bca";s:25:"top_level_item_bg_color_2";s:0:"";s:38:"top_level_item_bg_color_gradient_angle";s:3:"-90";s:29:"top_level_item_bg_hover_color";s:7:"#145bca";s:31:"top_level_item_bg_hover_color_2";s:0:"";s:44:"top_level_item_bg_hover_color_gradient_angle";s:3:"-90";s:26:"top_level_item_padding_top";s:2:"23";s:28:"top_level_item_padding_right";s:0:"";s:29:"top_level_item_padding_bottom";s:2:"23";s:27:"top_level_item_padding_left";s:0:"";s:25:"top_level_item_margin_top";s:0:"";s:27:"top_level_item_margin_right";s:0:"";s:28:"top_level_item_margin_bottom";s:0:"";s:26:"top_level_item_margin_left";s:0:"";s:27:"top_level_item_border_width";s:0:"";s:33:"top_level_item_border_width_right";s:0:"";s:34:"top_level_item_border_width_bottom";s:0:"";s:32:"top_level_item_border_width_left";s:0:"";s:26:"top_level_item_border_type";s:0:"";s:27:"top_level_item_border_color";s:0:"";s:33:"top_level_item_hover_border_width";s:0:"";s:39:"top_level_item_hover_border_width_right";s:0:"";s:40:"top_level_item_hover_border_width_bottom";s:0:"";s:38:"top_level_item_hover_border_width_left";s:0:"";s:32:"top_level_item_hover_border_type";s:4:"none";s:33:"top_level_item_hover_border_color";s:0:"";s:19:"dropdown_menu_width";s:3:"220";s:16:"dropdown_menu_bg";s:7:"#f1f4f9";s:18:"dropdown_menu_bg_2";s:0:"";s:31:"dropdown_menu_bg_gradient_angle";s:3:"-90";s:25:"dropdown_menu_padding_top";s:0:"";s:27:"dropdown_menu_padding_right";s:0:"";s:28:"dropdown_menu_padding_bottom";s:0:"";s:26:"dropdown_menu_padding_left";s:0:"";s:36:"dropdown_menu_border_radius_top_left";s:0:"";s:30:"dropdown_menu_radius_top_right";s:0:"";s:32:"dropdown_menu_radius_bottom_left";s:0:"";s:33:"dropwodn_menu_radius_bottom_right";s:0:"";s:26:"dropdown_menu_border_width";s:0:"";s:25:"dropdown_menu_border_type";s:4:"none";s:26:"dropdown_menu_border_color";s:0:"";s:31:"dropdown_submenu_item_text_font";s:9:"Open Sans";s:32:"dropdown_submenu_item_text_color";s:7:"#a6abbc";s:38:"dropdown_submenu_item_text_hover_color";s:7:"#145bca";s:36:"dropdown_submenu_item_text_font_size";s:4:"14px";s:38:"dropdown_submenu_item_text_font_weight";s:3:"400";s:38:"dropdown_submenu_item_text_line_height";s:2:"24";s:36:"dropdown_submenu_item_text_transform";s:10:"capitalize";s:41:"dropdown_submenu_item_text_letter_spacing";s:0:"";s:38:"dropdown_submenu_first_item_text_color";s:7:"#145bca";s:44:"dropdown_submenu_first_item_text_hover_color";s:7:"#145bca";s:42:"dropdown_submenu_first_item_text_font_size";s:4:"15px";s:44:"dropdown_submenu_first_item_text_font_weight";s:3:"400";s:44:"dropdown_submenu_first_item_text_line_height";s:2:"25";s:42:"dropdown_submenu_first_item_text_transform";s:9:"uppercase";s:47:"dropdown_submenu_first_item_text_letter_spacing";s:0:"";s:30:"dropdown_submenu_item_bg_color";s:7:"#f1f4f9";s:36:"dropdown_submenu_item_bg_hover_color";s:7:"#e0e0e0";s:33:"dropdown_submenu_item_padding_top";s:3:"5px";s:35:"dropdown_submenu_item_padding_right";s:4:"15px";s:36:"dropdown_submenu_item_padding_bottom";s:3:"5px";s:34:"dropdown_submenu_item_padding_left";s:4:"15px";s:32:"dropdown_submenu_item_margin_top";s:0:"";s:34:"dropdown_submenu_item_margin_right";s:0:"";s:35:"dropdown_submenu_item_margin_bottom";s:0:"";s:33:"dropdown_submenu_item_margin_left";s:0:"";s:34:"dropdown_submenu_item_border_width";s:0:"";s:33:"dropdown_submenu_item_border_type";s:4:"none";s:34:"dropdown_submenu_item_border_color";s:0:"";s:40:"dropdown_submenu_item_hover_border_width";s:0:"";s:39:"dropdown_submenu_item_hover_border_type";s:4:"none";s:40:"dropdown_submenu_item_hover_border_color";s:0:"";s:29:"widgets_first_item_margin_top";s:0:"";s:31:"widgets_first_item_margin_right";s:0:"";s:32:"widgets_first_item_margin_bottom";s:1:"5";s:30:"widgets_first_item_margin_left";s:0:"";s:41:"submenu_first_item_border_separator_width";s:0:"";s:40:"submenu_first_item_border_separator_type";s:4:"none";s:41:"submenu_first_item_border_separator_color";s:0:"";s:17:"megamenu_bg_color";s:7:"#f1f4f9";s:15:"mega_menu_width";s:4:"100%";s:20:"megamenu_padding_top";s:0:"";s:22:"megamenu_padding_right";s:0:"";s:23:"megamenu_padding_bottom";s:0:"";s:21:"megamenu_padding_left";s:0:"";s:31:"megamenu_border_radius_top_left";s:0:"";s:25:"megamenu_radius_top_right";s:0:"";s:27:"megamenu_radius_bottom_left";s:0:"";s:28:"megamenu_radius_bottom_right";s:0:"";s:26:"megamenu_menu_border_width";s:0:"";s:25:"megamenu_menu_border_type";s:4:"none";s:26:"megamenu_menu_border_color";s:0:"";s:36:"megamenu_menu_border_separator_width";s:3:"1px";s:35:"megamenu_menu_border_separator_type";s:5:"solid";s:36:"megamenu_menu_border_separator_color";s:7:"#f1f4f9";s:22:"megamenu_boxshadow_top";s:0:"";s:24:"megamenu_boxshadow_right";s:0:"";s:25:"megamenu_boxshadow_bottom";s:0:"";s:23:"megamenu_boxshadow_left";s:0:"";s:24:"megamenu_boxshadow_color";s:0:"";s:26:"widgets_heading_text_color";s:7:"#ffffff";s:32:"widgets_heading_text_hover_color";s:7:"#1e73be";s:30:"widgets_heading_text_font_size";s:4:"13px";s:32:"widgets_heading_text_font_weight";s:3:"600";s:32:"widgets_heading_text_line_height";s:2:"25";s:30:"widgets_heading_text_transform";s:9:"uppercase";s:35:"widgets_heading_text_letter_spacing";s:2:".5";s:40:"widget_first_item_border_separator_width";s:0:"";s:39:"widget_first_item_border_separator_type";s:4:"none";s:40:"widget_first_item_border_separator_color";s:7:"#ffffff";s:26:"widgets_heading_margin_top";s:0:"";s:28:"widgets_heading_margin_right";s:0:"";s:29:"widgets_heading_margin_bottom";s:0:"";s:27:"widgets_heading_margin_left";s:0:"";s:19:"widgets_padding_top";s:0:"";s:21:"widgets_padding_right";s:0:"";s:22:"widgets_padding_bottom";s:0:"";s:20:"widgets_padding_left";s:0:"";s:18:"widgets_margin_top";s:0:"";s:20:"widgets_margin_right";s:0:"";s:21:"widgets_margin_bottom";s:0:"";s:19:"widgets_margin_left";s:0:"";s:20:"widgets_border_width";s:0:"";s:19:"widgets_border_type";s:4:"none";s:20:"widgets_border_color";s:0:"";s:26:"widgets_hover_border_width";s:0:"";s:25:"widgets_hover_border_type";s:4:"none";s:26:"widgets_hover_border_color";s:0:"";s:21:"widgets_content_color";s:7:"#dddddd";s:20:"toggle_bar_alignment";s:5:"right";s:20:"toggle_btn_open_text";s:4:"Menu";s:21:"toggle_bar_close_icon";s:4:"true";s:21:"toggle_btn_text_color";s:7:"#ffffff";s:27:"toggle_btn_text_hover_color";s:7:"#ffffff";s:20:"toggle_bar_font_size";s:4:"14px";s:20:"togglebar_margin_top";s:2:"12";s:22:"togglebar_margin_right";s:0:"";s:23:"togglebar_margin_bottom";s:2:"12";s:21:"togglebar_margin_left";s:0:"";s:13:"toggle_bar_bg";s:7:"#2964d8";s:19:"toggle_bar_hover_bg";s:7:"#2844d3";s:26:"mobile_item_text_font_size";s:4:"14px";s:28:"mobile_item_text_font_weight";s:3:"400";s:28:"mobile_item_text_line_height";s:0:"";s:26:"mobile_item_text_transform";s:9:"uppercase";s:31:"mobile_item_text_letter_spacing";s:0:"";s:22:"mobile_menu_item_color";s:0:"";s:28:"mobile_menu_item_hover_color";s:0:"";s:28:"mobile_menu_item_padding_top";s:2:"10";s:30:"mobile_menu_item_padding_right";s:0:"";s:31:"mobile_menu_item_padding_bottom";s:2:"10";s:29:"mobile_menu_item_padding_left";s:0:"";s:27:"mobile_menu_item_margin_top";s:0:"";s:29:"mobile_menu_item_margin_right";s:0:"";s:30:"mobile_menu_item_margin_bottom";s:0:"";s:28:"mobile_menu_item_margin_left";s:0:"";s:14:"mobile_menu_bg";s:0:"";s:16:"mobile_menu_bg_2";s:0:"";s:29:"mobile_menu_bg_gradient_angle";s:3:"-90";s:10:"wpmm_class";s:0:"";s:10:"custom_css";s:0:"";s:9:"custom_js";s:0:"";s:19:"social_links_target";s:6:"_blank";s:12:"social_color";s:0:"";s:18:"social_hover_color";s:0:"";s:11:"social_icon";a:2:{s:4:"icon";a:1:{i:0;s:0:"";}s:3:"url";a:1:{i:0;s:0:"";}}s:14:"animation_type";s:10:"fadeindown";}";s:9:"post_type";s:10:"wpmm_theme";s:11:"post_status";s:7:"publish";}';

            return $wpmm_predefined_themes;
         }

	    /**
	     * Set initial menu
	     */
        public function set_wpmm_initial_menu(){
        	$wpmm_options = get_option('wpmm_options');

	        $get_menus = wpmm_get_theme_location();
	        foreach ($get_menus as $key => $value){
		        $wpmm_options['auto_intergration_menu'][] = $key;
		        update_option('wpmm_options', $wpmm_options);
		        break;
	        }
        }
    }

    //Init
    wp_megamenu_initial_setup::init();
}